
#include "MandelZoom.h"
#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <string.h>


void ViewOrtho()												// Set Up An Ortho View
{
	glMatrixMode(GL_PROJECTION);								// Select Projection
	glPushMatrix();												// Push The Matrix
	glLoadIdentity();											// Reset The Matrix

  int sWidth = glutGet(GLUT_WINDOW_WIDTH);
	int sHeight = glutGet(GLUT_WINDOW_HEIGHT);
	
	glOrtho( 0, sWidth , sHeight , 0, -1, 1 );		// Select Ortho Mode (640x480)
	glMatrixMode(GL_MODELVIEW);						// Select Modelview Matrix
	glPushMatrix();												// Push The Matrix
	glLoadIdentity();											// Reset The Matrix
}

void ViewPerspective()											// Set Up A Perspective View
{
	glMatrixMode( GL_PROJECTION );								// Select Projection
	glPopMatrix();												// Pop The Matrix
	glMatrixMode( GL_MODELVIEW );								// Select Modelview
	glPopMatrix();												// Pop The Matrix
}

/*



short SwapShort(short val)
{
	short		sValue = val;
	unsigned char	*v = (unsigned char *) &sValue;
	unsigned char t;
	t = v[0];
	v[0] = v[1];
	v[1] = t;
	return sValue;
}

void MSBLongToLocal(long *v)
{
	if (!IsBigEndian())
		*v = SwapLong(*v);
}

void MSBShortToLocal(short *v)
{
	if (!IsBigEndian())
		*v = SwapShort(*v);
}

void MSBui32ToLocal(ui32 *v)
{
	if (!IsBigEndian())
		*v = (ui32) SwapLong((ui32) *v);
}

void MSBui16ToLocal(ui16 *v)
{
	if (!IsBigEndian())
		*v = (ui16) SwapShort((ui16) *v);
}


*/
void MySetRect(MyRect *r, int left, int top, int right, int bottom)
{
	r->top = top;
	r->left = left;
	r->right = right;
	r->bottom = bottom;
}

void MyPaintRect(TextureImage *offW, MyRect *r, MyARGB *clr)
{
	unsigned long *dp;
	int	y,x;
	int	width,height;
	unsigned long	pix;
	width = r->right - r->left;
	height = r->bottom - r->top;

	// PC Version !!!
	pix = *((long *) clr) | 0xFF000000; // | 0x0FF;
	// (((long) clr->r) << 16) | (((long) clr->g) << 8) | clr->b;

	for (y = 0; y < height; ++y) {
		dp = (unsigned long *) &offW->imageData[(y+r->top) * offW->rowBytes + (r->left<<2)];
		for (x = 0; x < width; ++x) {
			*(dp++) = pix;
		}
	}
}

// byteorder format: r,g,b,a
long SwapLong(long val)
{
	long		lValue = val;
	unsigned char	*v = (unsigned char *) &lValue;
	unsigned char t;
	t = v[3];
	v[3] = v[0];
	v[0] = t;
	t = v[2];
	v[2] = v[1];
	v[1] = t;
	return lValue;
}


bool IsBigEndian()
{
	static char *testValStr = "\x00\x01";
	static short *testVal = (short *) testValStr;
	return (*testVal == 1); // 1 means we're big endian.  0x0100 means we're not.
}

void HSVtoRGB(MyHSV *hsv, MyARGB *rgb)
{
	double	h = hsv->hue * 360/255.0;
	double	s = hsv->saturation / 255.0;
	double	v = hsv->value / 255.0;
	float	r,g,b,f,m,n,k;
	int		i;

	if (s == 0.0) {
		r = g = b = v;
	}
	else {
		if (h >= 360.0)
			h = 0;
		else
			h /= 60.0;
		i = (int) h;
		f = h - i;
		m = v*(1-s);
		n = v*(1-s*f);
		k = v*(1-s*(1-f));
		switch (i) {
		case 0:
			r = v;
			g = k;
			b = m;
			break;
		case 1:
			r = n;
			g = v;
			b = m;
			break;
		case 2:
			r = m;
			g = v;
			b = k;
			break;
		case 3:
			r = m;
			g = n;
			b = v;
			break;
		case 4:
			r = k;
			g = m;
			b = v;
			break;
		default:
			r = v;
			g = m;
			b = n;
			break;
		}
	}
	rgb->r = r*255;
	rgb->g = g*255;
	rgb->b = b*255;
}
