/*
 *  Doublebuffer.cpp
 *  OpenGL Full Screen
 *
 *  Jim Bumgardner / Eugene Hourany
 *  Copyright (c) 2003 KrazyDad.com All rights reserved.
 *
 */
// TODO: Work on Windows Screensaver options.
//

#include "MandelZoom.h"

#include <math.h>
#include <ctype.h>

extern MandelWin *gMandelWin;

static int		 gWidth=800, gHeight=600;
static bool	 isScreensaver=false;


void displayC()
{
    if (gMandelWin->display())  
        glutSwapBuffers();
}

void idleHandler()
{
    gMandelWin->IdleUpdate();
    glutPostRedisplay();
}


void reshapeC(int w, int h)
{
	int x = w % 4;
	gWidth = w;
	gHeight = h;
	switch (x){
		case 1: w += 3; gMandelWin->resizeGL(w, h); break;
		case 2: w += 2; gMandelWin->resizeGL(w, h); break;
		case 3: w += 1; gMandelWin->resizeGL(w, h); break;
		case 0: gMandelWin->resizeGL(w, h); break;
	}
}

void myMouseMove(int x, int y)
{
	gMandelWin->HandleMouseMove(x, y);
}

void myMouseClick(int button, int state, int x, int y)
{
	gMandelWin->HandleMouseClick(button, state, x, y);	
}

void keyC(unsigned char key, int x, int y)
{
	switch (key){
		case 3:
		case 27:
						exit(0);
						break;
		default:	gMandelWin->HandleKey(key);	break;
	}
}

void specialKeyC(int key, int x, int y)
{
	gMandelWin->HandleSpecialKey(key);
}

void menuC(int itemNbr)
{
	switch (itemNbr) {
	case 1:	gMandelWin->ToggleFullscreen();	break;
	case 2:	gMandelWin->TakeSnapshot();			break;
	case 3:	exit(0);													break;
	}
}

int main(int argc, char **argv )
{
		for (int i = 1; i < argc; ++i) {
			if (argv[i][0] == '-') {
				for (char *p = argv[i]; *p; ++p) {
					switch (tolower(*p)) {
					case 's':
							isScreensaver = true;
							break;
					}
				}
			}
		}

    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB);
    glutInitWindowSize(gWidth, gHeight);
    glutInitWindowPosition(100, 100);
    glutCreateWindow(argv[0]);

    gMandelWin = new MandelWin(800, 600);
    
    glutDisplayFunc(displayC);
    glutReshapeFunc(reshapeC);
		glutMotionFunc(myMouseMove);
		glutPassiveMotionFunc(myMouseMove);
    glutMouseFunc(myMouseClick);
		glutKeyboardFunc(keyC);
		glutSpecialFunc(specialKeyC);
    glutIdleFunc(idleHandler);

		// glutCreateMenu(menuC); // returns menu-id, but unused...
		// glutAddMenuEntry("toggle Fullscreen", 1);
		// glutAddMenuEntry("take Snapshot", 2);
		// glutAddMenuEntry("Quit", 3);
		// glutAttachMenu(GLUT_RIGHT_BUTTON);

		if (isScreensaver)
			gMandelWin->ToggleFullscreen();

    glutMainLoop();
    delete gMandelWin;
    return 0;
}

#ifdef _DEBUG
FILE	*errFile;
void LogError(char *msg,...)
{
	char tbuf[128];
	va_list args;
	va_start(args,msg);
	vsprintf(tbuf,msg,args);
	va_end(args);

	if (errFile == NULL) {
		errFile = fopen("spark_log.txt","w");
		fprintf(errFile,"\nBegin Log\n\n");
	}
	fprintf(errFile,"%s", tbuf);
}
#else
void LogError(char *msg,...)
{
}
#endif
