#ifndef _H_MandelWin
#define _H_MandelWin	1

#include "MandelZoomLocal.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// #include "KS_VECTOR.h"

#define MandLimit		4.0
#define MinIter			256
#define MaxIter			4096	// only needed for cycle detection
#define MaxColors		1024
#define ExtraColors		8

#define kLeftButton		1
#define kMiddleButton	2
#define kRightButton	4


enum 	{// RM_BlackFill, 
			 RM_SineCPM,
			 RM_SineToR, 
       RM_SineLSM,  // sine
			 RM_Tiger,    // tiger with more subtle striping
       RM_TigerCon, // tiger with higher contrast striping
			 RM_BinaryDecomp,
			 RM_DEMM,     // black and white with thick filaments
			 // RM_ATan, 
			 // RM_Test, 
			 RM_NbrRenderModes};

//		 RM_Julia, RM_EPN,
enum  {RM_Grayscale, RM_HSVRamp, RM_RGBRamp, kNbrPalettes};



#define kFirstCellListID	2 // First Useable Displaylist by a Cell

// enum { CT_Photos, kNbrCellTypes };
#define F_UseMirrors	0x10000

#define kMirrorRad				4.0f
#define kMaxReflections		24
#define kBlockLength			15.0f

inline float rnd() { return (((FLOAT)rand())/RAND_MAX); }
inline int RandomI(int r) { return (int)(rnd()*r); }
inline float ease(float x) { return (x)*(x) * (3 - 2*(x)); }
// inline long FtoDW( FLOAT f ) { return *((DWORD*)&f); }

typedef struct {
	short top,left,right,bottom;
} MyRect;

typedef struct {
	unsigned char r,g,b;
} MyRGB;

typedef struct {
	unsigned char hue,saturation,value;
} MyHSV;


typedef MyRGB	Pd_Color;

typedef struct {
// PC Version
	unsigned char r,g,b,a; // a,r,g,b;
} MyARGB;




// typedef struct 
class TextureImage												// Create A Structure
{
public:
	GLubyte	*imageData;									// Image Data (Up To 32 Bits)
	GLuint	bpp;												// Image Color Depth In Bits Per Pixel.
	GLuint	rowBytes;
	GLuint	width;											// Image Width
	GLuint	height;											// Image Height
	GLuint	texID;											// Texture ID Used To Select A Texture

	// For zooming...
	//      start, delta
	GLfloat	scx, dcx;		// x
	GLfloat	scy, dcy;		// y
	GLfloat	scw, dcw, ecw, rcw;		// w
	GLfloat	sch, dch, ech, rch;		// h
	GLfloat	sa, da;			// alpha
public:
	TextureImage(int w, int h, int type);
	void SetupZoom(GLfloat sx, GLfloat ex,
								 GLfloat sy, GLfloat ey,
								 GLfloat sw, GLfloat ew,
								 GLfloat sh, GLfloat eh,
								 GLfloat sa, GLfloat ea);
	~TextureImage();

};

class SpriteList;

class MandelWin
{
public:
	int				width, height;
	int				mx, my,mouseDownFlags;     // mouse state
	int				curMIdx;
	float			m_fFramesPerSec, fLastScopeStart, elapsedTime;
	float			m_fTime;
	float			m_fLastKey;

	float			m_fStartFrameTime, m_fEndFrameTime;
	int				m_iFrames;
	int				m_desiredFPS, m_sleepAdjust;
	bool		  b_IsFullscreen;
	TextureImage	*offWorld1, *offWorld2, *fgWorld, *bgWorld;	// Main Texture - needs initing...
	char			errMsgBuf[256];

	// Mandel Stuff
	bool			showStats;
	bool			isDone, isJulia, isZooming, zoomOut;
	int				pX, pY, pixelsPerPass;
	int				resolution, pRes, resMask;
	int				renderMode, recurseFactor;
	int				curLimit;
	double		cutOff;

	double		startZoom, zoomDuration, startFade, fadeDuration;
	double		startRender, elapsedRender;

	// Color Stuff
	MyARGB	cTable[MaxColors+ExtraColors];
	double	cPhase[3];
	double	cFreq[3];
	int			paletteType;
	int			cAdjustComponent;

	
	// Normal Stuff
	double		rWidth,cx,cy,jx,jy,cOffsetX,cOffsetY;
	double		sx,dx, sy,dy, sx2,sy2,dx2,dy2;
	double		hFactor,vFactor,hWidth,demmDelta;


	MandelWin(int width, int height);
	~MandelWin();
	void initGL(int width, int height);
	void resizeGL(int width, int height);
	void OneTimeSceneInit();
	int  display();
	void UpdateFrame();
	void RenderSystem(bool drawBG);
	void RecordSystem();
	void InitTimer();
	void UpdateTimer();
	void IdleUpdate();
	void RenderToTexture();
	void TakeSnapshot();
	void ToggleFullscreen();
	bool HandleKey(int x);
	bool HandleSpecialKey(int x);
	void HandleMouseMove(int x, int y);
	void HandleMouseClick(int button, int state, int x, int y);
	void ErrorMessage(char *str);

	void ResetRender();
	void InitColors(void);
	void GetCPixel(int x, int y, MyARGB *argb);
	// void SetCPixel(int x, int y, MyARGB *argb);
	int ComputePixelColor(double x, double y);
	void ZoominMandelbrot(int x, int y);
	void ZoomoutMandelbrot(int x, int y);
	void ScrollMandelbrot(double x, double y);
	void DrawStats();
	void DrawString(int x, int y, char *string);

	inline void MandelWin::SetCPixel(int x, int y, MyARGB *argb)
	{
			unsigned long *dp = (unsigned long *) &fgWorld->imageData[y*fgWorld->rowBytes + (x<<2)];
			*dp = *((unsigned long *) argb) | 0xFF000000; //   | 0x0FF;
	}
};

extern MandelWin	*gMandelWin;



#define K_PI		3.14159f
#define kToRadians	(K_PI/180)


// Utils
bool LoadJPEGTexture(TextureImage *texture, const unsigned char *maskname, unsigned int masksize, int mode);
void ViewOrtho();
void ViewPerspective();


typedef struct 
{
		unsigned int pos,size; 
		const char *buf;
} 
MFILE;

MFILE *mopen(const unsigned char *buf,unsigned int size);
void  mclose(MFILE *m);

extern void LogError(char *msg,...);

// Utils
void MySetRect(MyRect *r, int top, int left, int right, int bottom);
void MyOffsetRect(MyRect *r, int ox, int oy);
void ErrorMessage(char *tmp,...);
void ErrorExit(char *str,...);
void MyPaintRect(TextureImage *offW, MyRect *r, MyARGB *rgb);
bool IsBigEndian();
long SwapLong(long val);
short SwapShort(short val);
void HSVtoRGB(MyHSV *hsv, MyARGB *rgb);

#define MyMin(a,b)	((a) <= (b)? (a) : (b))
#define MyMax(a,b)	((a) >= (b)? (a) : (b))


#ifdef _DEBUG
#define D	
#else
#define D	if (0)
#endif




#endif
