﻿// Ocean - Jim Bumgardner

kNbrPts = 40;
SW = Stage.width;
SH = Stage.height;

MovieClip.prototype.makeWave = function(deep, clr, jit,turbProb)
{
	this.pts = [];
	this.springs = [];
	this.clr = clr;
	this.jit = jit;
	this.turbProb = turbProb;
	this.deep = deep;
	this.stiffK = .3;
	this.kDamp = .85;
	var segLen = (SW+100)/kNbrPts;
	for (var i = 0; i < kNbrPts; ++i) {
		this.pts[i] = {x:-50+i*segLen, y:0, fx:0,fy:0, vx:0,vy:0, restLen: .5*segLen,jy:0};
	}
}

MovieClip.prototype.simWave = function()
{
	var i;

	// Initialize forces with some noise
	for (i = 0; i < this.pts.length; ++i) {
		this.pts[i].fx = 0;
		if (Math.random() < this.turbProb)
			this.pts[i].fy = Math.random()*this.jit-this.jit/2;
		else
			this.pts[i].fy = 0;
	}
  // compute spring forces
	for ( i = 0; i < this.pts.length-1; ++i) {
		var pt1 = this.pts[i];
		var pt2 = this.pts[i+1];
		var dx = pt2.x - pt1.x;
		var dy = pt2.y - pt1.y;
		var dist = Math.sqrt(dx*dx+dy*dy);
    var f1 = this.stiffK * (dist - pt1.restLen);
		var spr_fx = f1 * dx/dist;
		var spr_fy = f1 * dy/dist;
		if (i != 0) {
			pt1.fx += spr_fx;
			pt1.fy += spr_fy;
		}
		if (i !=  this.pts.length-2) {
			pt2.fx -= spr_fx;
			pt2.fy -= spr_fy;
		}
	}
	// trace(this.pts[2].fx + ", " + this.pts[2].fy);
	this.clear();
	// trace(this.clr);
	this.beginFill(this.clr, 100);
	this.moveTo(this.pts[0].x, this.pts[0].y);

	for (i = 1; i < this.pts.length-1; ++i) 
	{
		pt = this.pts[i];
		pt.vx *= this.kDamp;
		pt.vy *= this.kDamp;
		pt.vx += pt.fx;
		pt.vy += pt.fy;
		pt.x += pt.vx;
		pt.y += pt.vy;

		this.lineTo(pt.x, pt.y);
	}
	i = this.pts.length-1;
  this.lineTo(this.pts[i].x, this.pts[i].y);
  this.lineTo(this.pts[i].x, this.deep);
	this.lineTo(this.pts[0].x, this.deep);
	this.lineTo(this.pts[0].x, this.pts[0].y);
	this.endFill();
}

var d = 0;
var vd = 64;
kNbrLines = 7;

function mergeColor(a,b,mix)
{
	var r1 = a >> 16;
	var g1 = (a >> 8) & 0xFF;
	var b1 = a & 0xFF;
	var r2 = b >> 16;
	var g2 = (b >> 8) & 0xFF;
	var b2 = b & 0xFF;
	r1 = r1*(1-mix)+r2*mix;
	g1 = g1*(1-mix)+g2*mix;
	b1 = b1*(1-mix)+b2*mix;
	return (r1 << 16) | (g1 << 8) | b1;
}

for (var i = 0; i < kNbrLines; ++i) {
	var r = i/(kNbrLines-1);
	var ir = 1-r;
	var mc = _root.createEmptyMovieClip("mc"+i, kNbrLines*2+1-i*2);
	mc._x = 0;
	mc._y = SH/2-d;
	var deep;
	if (i == 0)
		deep = SH/2;
	else
		deep = d*2;
	mc.makeWave(deep, mergeColor(0x333747,0xD6D5D9,r*.9),.1+4*ir*ir,.1);
	mc.onEnterFrame = mc.simWave;
	d += vd;
	vd /= 2;
}

SS = 10;
MovieClip.prototype.drawShark = function()
{
	this.clear();
	this.beginFill(mergeColor(0x333333, mergeColor(0x666699,0xD6D5D9,.8), .5), 100);
	this.moveTo(-2*SS, 0);
	this.curveTo(-0.5*SS, -1.5*SS, -1*SS,-2.75*SS);
	this.curveTo(-1*SS, -3*SS, -.75*SS,-3*SS);
	this.curveTo(1*SS, -2*SS, 2*SS, 0);
	this.lineTo(-2*SS, 0);
	this.endFill();
}

MovieClip.prototype.moveShark = function()
{
	this._x += 2;
	if (this._x > SW+this._width)
		this._x = -SW;
	var t = getTimer()*.001;
	this._y = this.cy+Math.sin(t)*5;
	this._rotation = Math.sin(t+.9)*10;
}

var mc = _root.createEmptyMovieClip("shark", 12);
mc.cy = SH/2.8;
mc._x = -SW;
mc._y = SH/4;
mc.drawShark();
mc.onEnterFrame = mc.moveShark;