// Animated grass - Jim Bumgardner
//

DAMP = 0.9
TSPEED = 15  // turbulence (individual motion)
WSPEED = 2   // wind (common motion)

windx = 0;   // Added these initializations for Flash Player 7
windy = 0;

MovieClip.prototype.drawBlade = function()
{
  this.clear();
  this.moveTo(-5,0);
  this.beginFill(this.clr, 100);
  this.curveTo(this.cx-5,this.cy,this.ex, this.ey);
  this.curveTo(this.cx+5,this.cy, 5, 0);
  this.lineTo(-5,0);
  this.endFill();
}

function bladeMove()
{
    this.vx1 += Math.random()*TSPEED-TSPEED/2 + windx;
    this.vy1 += Math.random()*TSPEED-TSPEED/2;
    this.vx2 += Math.random()*TSPEED-TSPEED/2 + windx;
    this.vy2 += Math.random()*TSPEED-TSPEED/2;
    this.vx1 *= DAMP;   // damping
    this.vx2 *= DAMP;
    this.vy1 *= DAMP;
    this.vy2 *= DAMP;
    this.cx = this.cxR + this.vx1;
    this.cy = this.cyR + this.vy1;
    this.ex = this.exR + this.vx2 + windx;
    this.ey = this.eyR + this.vy2 + windy;
    this.drawBlade();
// Add these lines to travel horizontally
/*
    this._x -= 3;
    if (this._x < -5)
        this._x += Stage.width+10;
 */
}

function windBlow()
{
    windx += Math.random()*WSPEED - WSPEED/2;
    windx *= DAMP;
}

for (var i = 0; i <= 100; ++i) {
    var mc = this.createEmptyMovieClip("fish_mc_"+i, i);
    mc._x = i*5;
    mc._y = Stage.height-50;
    mc.clr = (0x20 + random(0x45)) << 8;
    mc.cx = mc.cxR = Math.random()*10-5;
    mc.cy = mc.cyR = -(75+Math.random()*50);
    mc.ex = mc.exR = Math.random()*10-5;
    mc.ey = mc.eyR = mc.cyR*2;
    mc.vx1 = 0;      // Added these initializataions for Flash Player 7
    mc.vx2 = 0;
    mc.vy1 = 0;
    mc.vy2 = 0;
    mc.onEnterFrame = bladeMove;
}

this.onEnterFrame = windBlow;


// Slider UI stuff - I usually prefer to roll my own sliders, rather than
// using components, since the code often ends up being nearly the
// same size, and I prefer having code I can see & understand.
// Nonetheless, I'm probably asking for trouble...
//

MovieClip.prototype.setupSlider = function(lab,min,max,val,changeFunc)
{
   this.minv = min;
   this.maxv = max;
   this.range = max - min;
   this.val = val;
   this.changeFunc = changeFunc;
   this.its_label.text = lab;
   this.its_value.text = val;
   this.knob_mc.useHandCursor = true;
   this.knob_mc._x = (this.val - this.minv)*200/this.range;
   this.changeFunc(this.val);
   this.onMouseMove = function() 
   {
      if (!this.dragging)
        return;
      x = this._xmouse;
      if (x >= 0 && x <= 200) 
      {
          this.knob_mc._x = x;
          var r = x/200;
          this.val = this.minv + r*this.range;
          this.its_value.text = Math.round(this.val);
          this.changeFunc(this.val);
      }
   };
   this.knob_mc.onPress = function() { this._parent.dragging = true; };
   this.knob_mc.onRelease = function() { this._parent.dragging = false; };
   this.knob_mc.onReleaseOutside = function() { this._parent.dragging = false; };
}

function setTurb(t)
{
    TSPEED = t;
}

function setWind(w)
{
    WSPEED = w;
}

// Setup the 4 sliders...
slider1_mc.setupSlider('Turbulence',0,30, TSPEED,setTurb);
slider2_mc.setupSlider('Wind',0,30, WSPEED,setWind);
