﻿package {
	// Animated Grass - Actionscript 3 (Grass Blade) - Jim Bumgardner 2008
	import flash.events.Event;
	import flash.display.Sprite;
	import flash.display.DisplayObject;
	import flash.events.MouseEvent;

	public class GrassBlade extends Sprite
	{
		var clr, cx, cy, ex, ey, vx1, vx2, vy1, vy2, cxR, cyR, exR, eyR;
		
		public function GrassBlade()
		{
			clr = (0x20 + Math.floor(Math.random()*0x45)) << 8;
			cx = cxR = Math.random()*10-5;
			cy = cyR = -(75+Math.random()*50);
			ex = exR = Math.random()*10-5;
			ey = eyR = cyR*2;
			vx1 = 0;
			vx2 = 0;
			vy1 = 0;
			vy2 = 0;
			addEventListener(Event.ENTER_FRAME, bladeMove);
		}

		function drawBlade()
		{
		  graphics.clear();
		  graphics.moveTo(-5,0);
		  graphics.beginFill(clr, 100);
		  graphics.curveTo(cx-5, cy, ex, ey);
		  graphics.curveTo(cx+5, cy, 5, 0);
		  graphics.lineTo(-5,0);
		  graphics.endFill();
		}

		function bladeMove(evt)
		{
			var tspeed = GrassAnimation.TSPEED;
			var damp = GrassAnimation.DAMP;
			
			this.vx1 += Math.random()*tspeed-tspeed/2 + GrassAnimation.windx;
			this.vy1 += Math.random()*tspeed-tspeed/2;
			this.vx2 += Math.random()*tspeed-tspeed/2 + GrassAnimation.windx;
			this.vy2 += Math.random()*tspeed-tspeed/2;
			this.vx1 *= damp;   // damping
			this.vx2 *= damp;
			this.vy1 *= damp;
			this.vy2 *= damp;
			this.cx = this.cxR + this.vx1;
			this.cy = this.cyR + this.vy1;
			this.ex = this.exR + this.vx2 + GrassAnimation.windx;
			this.ey = this.eyR + this.vy2 + GrassAnimation.windy;
			drawBlade();
		}

	} // end class
} // end package