﻿// Animated grass - Actonscript 3 Version - Jim Bumgardner, 2008
//
package {
	import flash.events.Event;
	import flash.display.DisplayObject;
	import flash.display.Sprite;

	public class GrassAnimation extends Sprite
	{

		static var DAMP = 0.9;
		static var TSPEED = 15;  // turbulence (individual motion)
		static var WSPEED = 2;   // wind (common motion)
	
		static var windx = 0;   // Added these initializations for Flash Player 7
		static var windy = 0;
	
		public function GrassAnimation(itsPar, slider1, slider2)
		{
			for (var i = 0; i <= 100; ++i) {
				mc = new GrassBlade();
				mc.x = i*5;
				mc.y = itsPar.stage.stageHeight-50;
				itsPar.addChild(mc);
			}
			
			itsPar.addEventListener(Event.ENTER_FRAME, windBlow);
			
			// Setup the 2 sliders...
			new SliderController(slider1, 'Turbulence', 0,30, TSPEED, setTurb);
			new SliderController(slider2, 'Wind', 0,30, WSPEED, setWind);
		}
	
		static function windBlow(evt)
		{
			windx += Math.random()*WSPEED - WSPEED/2;
			windx *= DAMP;
		}
	
		static function setTurb(t)
		{
			TSPEED = t;
		}
	
		function setWind(w)
		{
			WSPEED = w;
		}

	} // end class
} // end package
