﻿// Fern Fractal - Jim Bumgardner
// 
maxLevels = 6;
initBendAngle = 15;
initBranchAngle = 37;
trunkRatio = .1;
branchRatio = .4;
heightScale = 2.5;
colors = [];
SW = Stage.width;
SH = Stage.height;

// This version has been slightly modified
// compared to the version on the website.
//
MovieClip.prototype.drawFern = function(x,y,a,rad,level)
{
	var cx = x+Math.cos(a)*rad*trunkRatio;
	var cy = y+Math.sin(a)*rad*trunkRatio;
	this.lineStyle(level, colors[level], 100);
	this.lineTo(cx, cy);
	if (level > 0) {
		a += bendAngle;
		level--;
		this.drawFern(cx,cy,a-branchAngle,rad*branchRatio,level);	  
		this.moveTo(cx,cy);
		this.drawFern(cx,cy,a+branchAngle,rad*branchRatio,level);	  
		this.moveTo(cx,cy);
		this.drawFern(cx,cy,a,rad*antiTrunkRatio,level);
	}
}

function redrawFern()
{
	bendAngle = initBendAngle*Math.PI/180;
	branchAngle = initBranchAngle*Math.PI/180;
	lastMaxLevels = maxLevels;
	antiTrunkRatio = 1-trunkRatio;
	startAngle = -Math.PI/2;
	for (i = 0; i <= maxLevels; ++i)
		colors[i] = Math.floor(255*(1-i/(maxLevels+1)))<<8
	var x = SW/2;
	var y = SH-100;
	_root.clear();
	_root.moveTo(x,y);
	_root.drawFern(x,y,startAngle,(SH-100)*heightScale, maxLevels);
}
redrawFern();

MovieClip.prototype.setupSlider = function(lab,min,max,val,changeFunc)
{

   this.minv = min;
   this.maxv = max;
   this.range = max - min;
   this.val = val;
   this.changeFunc = changeFunc;
   this.its_label.text = lab;
   this.knob_mc.useHandCursor = true;
   this.knob_mc._x = (this.val - this.minv)*this.bar_mc._width/this.range;
   this.setTextVal = function()
   {
	  if (this.isInteger)
		  this.its_value.text = Math.floor(this.val);
	  else if (this.range < 10)
		  this.its_value.text = Math.round(this.val*100)/100;
	  else if (this.range < 50)
		  this.its_value.text = Math.round(this.val*10)/10;
	  else
		  this.its_value.text = Math.round(this.val);
   }
   this.setTextVal();
   this.changeFunc(this.val);

   this.onMouseMove = function() 
   {
	  if (!this.dragging)
		return;
	  x = this.knob_mc._x;
	  var r = x/this.bar_mc._width;
	  this.val = this.minv + r*this.range;
	  this.setTextVal();
	  this.changeFunc(this.val);
   };
   this.knob_mc._xscale = this.knob_mc._yscale = 90;
   this.knob_mc.onRollOver = function() { this._xscale = this._yscale = 100; };
   this.knob_mc.onRollOut = function() { this._xscale = this._yscale = 90; };
   this.knob_mc.onPress = function() { this._parent.dragging = true; this.startDrag(false,0,this._y,this._parent.bar_mc._width,this._y); };
   this.knob_mc.onReleaseOutside = this.knob_mc.onRelease = function() { this._parent.dragging = false; this.stopDrag(); };
}

slider1_mc.setupSlider('recursion',1,8, maxLevels,function(t) { maxLevels = Math.floor(t); if (maxLevels != lastMaxLevels) redrawFern(); } );
slider1_mc.isInteger = true;
slider2_mc.setupSlider('bend angle',-60,60, initBendAngle,function(t) { initBendAngle = t; redrawFern(); } );
slider3_mc.setupSlider('branch angle',0,90, initBranchAngle,function(t) { initBranchAngle = t; redrawFern(); } );
slider4_mc.setupSlider('trunk ratio',0,.75, trunkRatio,function(t) { trunkRatio = t; redrawFern(); } );
slider5_mc.setupSlider('branch ratio',.1,2, branchRatio,function(t) { branchRatio = t; redrawFern(); } );
slider6_mc.setupSlider('height',.1,8, heightScale,function(t) { heightScale = t; redrawFern(); } );
