﻿package 
{
	// SliderController - Actionscript 3 Version by Jim Bumgardner
	import flash.events.Event;
	import flash.display.Sprite;
	import flash.display.DisplayObject;
	import flash.display.GradientType;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
    import Slider_mc;
	
	public class SliderController extends Sprite
	{
		var dragging:Boolean = false;
		var minv,maxv,range,val;
		var changeFunc;
		var itsMC;
		public var isInteger:Boolean = false;
		
		public function SliderController(mc, lab,min,max,val,changeFunc)
		{
		   this.itsMC = mc;
		   this.minv = min;
		   this.maxv = max;
		   this.range = max - min;
		   this.val = val;
		   this.changeFunc = changeFunc;
		   this.itsMC.its_label.text = lab;
		   this.itsMC.knob_mc.buttonMode = true;
		   this.itsMC.knob_mc.x = (this.val - this.minv)*this.itsMC.bar_mc.width/this.range;
		   setTextVal();
		   changeFunc(this.val);
		   this.itsMC.knob_mc.scaleX = this.itsMC.knob_mc.scaleY = .9;
		   this.itsMC.knob_mc.addEventListener(MouseEvent.MOUSE_OVER, handleRollOver);
		   this.itsMC.knob_mc.addEventListener(MouseEvent.MOUSE_OUT, handleRollOut);
		   this.itsMC.knob_mc.addEventListener(MouseEvent.MOUSE_DOWN, handlePress);
		   this.itsMC.knob_mc.addEventListener(MouseEvent.MOUSE_UP, handleRelease);
		}
		
		private function handleRollOver(evt)
		{
			evt.target.scaleX = evt.target.scaleY = 1;
		}
		private function handleRollOut(evt)
		{
			evt.target.scaleX = evt.target.scaleY = .9;
		}
		private function handlePress(evt)
		{
			dragging = true;
			var bounds:Rectangle  = new Rectangle(0,evt.target.y,itsMC.bar_mc.width,0);
			evt.target.startDrag(false,bounds);
			evt.target.addEventListener(Event.ENTER_FRAME, this.handleMove);
		}
		private function handleRelease(evt)
		{
			dragging = false;
			evt.target.stopDrag();
			evt.target.removeEventListener(Event.ENTER_FRAME, this.handleMove);
		}
		
		public function setTextVal()
		{
		  // trace("Setting text for range " + this.range + " val " + this.val);
		  if (range < 1)
			this.itsMC.its_value.text = Math.round(this.val*100)/100;
		  else if (range < 10)
			this.itsMC.its_value.text = Math.round(this.val*10)/10;
		  else
			this.itsMC.its_value.text = Math.round(this.val);
		  if (isInteger) {
			this.val = Math.round(this.val);
		  	this.itsMC.its_value.text = this.val;
		  }
		}
		
		private function handleMove(evt)
		{
		  if (!this.dragging)
			return;
			
		  var px = evt.target.x;
		  var r = px/this.itsMC.bar_mc.width;
		  this.val = this.minv + r*this.range;
		  // trace(" v = " + this.val);
		  setTextVal();
		  changeFunc(this.val);
		}
    
  	} // end class
} // end package