﻿// Fern Fractal - Actionscript 3 Version - Jim Bumgardner 2008
// 

package 
{
	import flash.events.Event;
	import flash.display.DisplayObject;
	import flash.display.Sprite;

	public class FernSprite extends Sprite
	{
		var maxLevels = 6;
		var initBendAngle = 15;
		var initBranchAngle = 37;
		var trunkRatio = .1;
		var branchRatio = .4;
		var heightScale = 2.5;
		var colors = [];
		var SW,SH
		
		public function FernSprite(parMC)
		{
			SW = parMC.stage.stageWidth;
			SH = parMC.stage.stageHeight;
			redrawFern();
			parMC.addChild(this);
		}

		public function SetupSliders(s1,s2,s3,s4,s5,s6)
		{
			var s1c = new SliderController(s1, 'recursion',1,10, maxLevels,function(t) { maxLevels = Math.floor(t); if (maxLevels != lastMaxLevels) redrawFern(); } );
			s1c.isInteger = true;
			new SliderController(s2, 'bend angle',-60,60, initBendAngle,function(t) { initBendAngle = t; redrawFern(); } );
			new SliderController(s3, 'branch angle',0,90, initBranchAngle,function(t) { initBranchAngle = t; redrawFern(); } );
			new SliderController(s4, 'trunk ratio',0,.75, trunkRatio,function(t) { trunkRatio = t; redrawFern(); } );
			new SliderController(s5, 'branch ratio',.1,2, branchRatio,function(t) { branchRatio = t; redrawFern(); } );
			new SliderController(s6, 'height',.1,8, heightScale,function(t) { heightScale = t; redrawFern(); } );
		}
		
		// This version has been slightly modified
		// compared to the version on the website.
		//
		function drawFern(px,py,a,rad,level)
		{
			var cx = px+Math.cos(a)*rad*trunkRatio;
			var cy = py+Math.sin(a)*rad*trunkRatio;
			graphics.lineStyle(level, colors[level], 100);
			graphics.lineTo(cx, cy);
			if (level > 0) {
				a += bendAngle;
				level--;
				drawFern(cx,cy,a-branchAngle,rad*branchRatio,level);	  
				graphics.moveTo(cx,cy);
				drawFern(cx,cy,a+branchAngle,rad*branchRatio,level);	  
				graphics.moveTo(cx,cy);
				drawFern(cx,cy,a,rad*antiTrunkRatio,level);
			}
		}

		function redrawFern()
		{
			bendAngle = initBendAngle*Math.PI/180;
			branchAngle = initBranchAngle*Math.PI/180;
			lastMaxLevels = maxLevels;
			antiTrunkRatio = 1-trunkRatio;
			startAngle = -Math.PI/2;
			for (var i = 0; i <= maxLevels; ++i)
				colors[i] = Math.floor(255*(1-i/(maxLevels+1)))<<8;
			var px = SW/2;
			var py = SH-100;
			graphics.clear();
			graphics.moveTo(px,py);
			drawFern(px,py,startAngle,(SH-100)*heightScale, maxLevels);
		}
	} // end class
} // end package


