﻿MW = 320
MH = 256;
CW = 1024;
CH = 256;
FLY_RATE = .0002; 
kMaxCloudLayers = 3;

function drawCloud()
{
	var phase = this.startPhase + getTimer()*FLY_RATE;
	var iphase = Math.floor(phase);
	var rphase = phase - iphase;
	if (iphase != this.phaseCtr)
	{
		this.phaseCtr++;
		// trace("Current x = " + this.clouds_mc._x);
		this.clouds_mc._x = random(CW-MW)-(CW-MW)/2;
		this.xs = random(2)? -1 : 1;
		this.ys = random(2)? -1 : 1;
		// this.swapDepths(0);
		// trace("    changed to " + this.clouds_mc._x);
	}

	if (rphase < .5)
		this._alpha = 50-Math.cos(rphase*2*Math.PI)*50;
	else
		this._alpha = 50-Math.cos((1-rphase)*2*Math.PI)*50;
/*
	if (rphase < .5)
		this._alpha = rphase*200;
	else
		this._alpha = (1-rphase)*200;
*/
		
		
	// fix this to a constant zoom equation using log and rphase
//	var zoom = 110+Math.pow(200,rphase);
	var zoom = 110+200*rphase;
	this._xscale = zoom*this.xs;
	this._yscale = zoom*this.ys;
	this._rotation = rphase*30;
}

function init()
{
	for (var i = 0; i < kMaxCloudLayers; ++i) {
		var nam = "clouds_" + i;
		this.attachMovie("tint_clouds", nam, i);
		this[nam]._x = MW/2;
		this[nam]._y = MH/2;
		this[nam].clouds_mc._x = random(CW-MW)-(CW-MW)/2;
		this[nam].xs = random(2)? -1 : 1;
		this[nam].ys = random(2)? -1 : 1;
		this[nam].startPhase = i/kMaxCloudLayers;
		this[nam].phaseCtr = 0;
		this[nam].onEnterFrame = drawCloud;
	}
}

init();
