﻿// CloudSprite - Actionscript 3 Version of Zooming Clouds - Jim Bumgardner 2008

package {
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.events.Event;
	import flash.utils.getTimer;

	public class CloudSprite extends Sprite
	{
		static const MW = 320;
		static const MH = 256;
		static const CW = 1024;
		static const CH = 256;
		static const FLY_RATE = .0002; 
		static const kMaxCloudLayers = 3;

		var xs, ys, phaseCtr, startPhase;
		var clouds_mc:Sprite;
		
		public function CloudSprite(startPhase)
		{
			var bmap = new Bitmap( new CloudsBitmapData(0,0) ); // attach bitmap from library
			bmap.x = -bmap.width/2;                             // center it
			bmap.y = -bmap.height/2;
			clouds_mc = new Sprite();                           // attach it to a sprite
			clouds_mc.addChild(bmap);
			clouds_mc.x =  Math.floor(Math.random()*(CW-MW))  -  (CW-MW)/2;
			addChild(clouds_mc);                                // attach the sprite
			                                                    // the reason for the extra nested sprite is so we can slide the cloud
																// image from side to side randomly, while still making it seem to zoom from the center
																// we slide the nested sprite (clouds_mc) and zoom it's parent (this object)
			x = MW/2;                                           // center ourselves
			y = MH/2;
			alpha = 0;
			xs = Math.floor(Math.random()*2)? -1 : 1;
			ys = Math.floor(Math.random()*2)? -1 : 1;
			this.startPhase = startPhase;;
			phaseCtr = 0;
			addEventListener(Event.ENTER_FRAME, drawCloud);
		}

		public static function initClouds(parMC)
		{
			for (var i = 0; i < kMaxCloudLayers; ++i) {
				parMC.addChild(new CloudSprite(i/kMaxCloudLayers));
			}
		}

		function drawCloud(evt)
		{
			var phase = this.startPhase + getTimer()*FLY_RATE;
			var iphase = Math.floor(phase);
			var rphase = phase - iphase;
			if (iphase != this.phaseCtr)
			{
				phaseCtr++;
				clouds_mc.x = Math.floor(Math.random()*(CW-MW))  -  (CW-MW)/2;
				xs = Math.floor(Math.random()*2)? -1 : 1;
				ys = Math.floor(Math.random()*2)? -1 : 1;
			}
		
			if (rphase < .5)
				alpha = .5-Math.cos(rphase*2*Math.PI)*.5;
			else
				alpha = .5-Math.cos((1-rphase)*2*Math.PI)*.5;
				
				
			var zoom = 1.10+2.00*rphase;
			scaleX = zoom * xs;
			scaleY = zoom * ys;
			this.rotation = rphase*30;
		}
	} // end class
} // end package
